
*   ***************************************************************** *;
*   ***************************************************************** *;
*   File-Name:   survey.do            	                              *;
*   Date:        Sept 20, 2023   		                              *;
*   Author:     Lisa Dellmuth					                      *;
*   Input File:  survey.dta                                           *; 
*   ****************************************************************  *;
*   ****************************************************************  *;

*   ****************************************************************  *;
*   This file replicates the numerical results in the paper           *;
*	International Bureaucrats' Attitudes Toward Global Climate        *;
*	Adaptation" in npj Clim Action									  *;
*   ****************************************************************  *;
 

version 17.0

set scheme plotplain

use survey.dta, clear


*   ****************************************************************  *;
*   Descriptives and creation of variables
*   ****************************************************************  *;

*How many observations there are per organization

tab io // International organization (IO)

*How often they deal with climate risks

by ionum, sort: tab oftendeal

*How many years they have worked in the organization?

gen yearsworked=2018-startworkinio
by ionum, sort: tab yearsworked

*Recode seniority

tab senior, nol
gen seniority=.
replace seniority=1 if senior==2 //interns 
replace seniority=2 if senior==1|senior==5 // tech staff and consultants
replace seniority=3 if senior==3 //low manag
replace seniority=4 if senior==4 //mid manag
replace seniority=5 if senior==6 //top manag

*Perceived awareness of climate risks in IO

by ionum, sort:tab spread
 
*Cronbach's alpha of index variables (Fig. 1 and 2)

alpha fr_humansec fr_statesec fr_health fr_migr

*Create index for Figure 1

gen multipleframes4=fr_humansec + fr_statesec + fr_health + fr_migr


*   ****************************************************************  *;
*   Figure 1
*   ****************************************************************  *;

graph box multipleframes4, ///
over(ionum, sort(median) descending) ///
ytitle("Additive index") ylabel(,gstyle(minor)) ///
legend(off) title(Human security)  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100)) saving(fig1.gph, replace)


*   ****************************************************************  *;
*   Figure 2
*   ****************************************************************  *;

graph box fr_humansec, ///
over(ionum, sort(median) descending) ///
ylabel(1 "Strongly opposed" 2 "Opposed" 3 "Somewhat opposed" 4 "Neutral" 5 "Somewhat in favor" 6 "In favor" 7 "Strongly in favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Human security (a))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig2a.gph, replace)

graph box fr_statesec, ///
over(ionum, sort(median) descending) ///
ylabel(1 "Strongly opposed" 2 "Opposed" 3 "Somewhat opposed" 4 "Neutral" 5 "Somewhat in favor" 6 "In favor" 7 "Strongly in favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(State security (b))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig2b.gph, replace)

graph box fr_health, ///
over(ionum, sort(median) descending) ///
ylabel(1 "Strongly opposed" 2 "Opposed" 3 "Somewhat opposed" 4 "Neutral" 5 "Somewhat in favor" 6 "In favor" 7 "Strongly in favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Health (c))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig2c.gph, replace)

graph box fr_migr, ///
over(ionum, sort(median) descending) ///
ylabel(1 "Strongly opposed" 2 "Opposed" 3 "Somewhat opposed" 4 "Neutral" 5 "Somewhat in favor" 6 "In favor" 7 "Strongly in favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Migration (d))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig2d.gph, replace)

graph combine fig2a.gph fig2b.gph fig2c.gph fig2d.gph, ycommon



*   ****************************************************************  *;
*   Figure 3
*   ****************************************************************  *;

graph box pref_coll , ///
over(ionum, sort(median) descending) ///
ylabel(0 "Oppose" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "Favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Collaborate with other IOs on climate risks (a))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig3a.gph, replace)

graph box pref_reports , ///
over(ionum, sort(median) descending) ///
ylabel(0 "Oppose" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "Favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Integrate climate risks in reports (b))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig3b.gph, replace)

graph box pref_power , ///
over(ionum, sort(median) descending) ///
ylabel(0 "Oppose" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "Favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(More power to address climate risks (c))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig3c.gph, replace)
 
graph box pref_budget, ///
over(ionum, sort(median) descending) ///
ylabel(0 "Oppose" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "Favor", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Greater budget to address climate risks (d))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig3d.gph, replace)
     

graph combine fig3a.gph fig3b.gph fig3c.gph fig3d.gph, ycommon



*   ****************************************************************  *;
*   Figure 4
*   ****************************************************************  *;


cd "/Users/ldell/"

graph box donors, ///
over(ionum, sort(median) descending) ///
ylabel(0 "Not at all" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "To a very high degree", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Donor willingness (a))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig4a.gph, replace)

graph box know, ///
over(ionum, sort(median) descending) ///
ylabel(0 "Completely uncertain" 1 "1" 2 "2" 3 "3" 4 "4" 5 "5" 6 "6" 7 "7" 8 "8" 9 "9" 10 "Completely certain", labsize(small) angle(horizontal) ///
glcolor(gs14) gmax) bar(3, color(g2)) ytitle("") ylabel(,gstyle(minor)) ///
legend(off) title(Knowledge certainty (b))  ///
box(1, fcolor(gs12) fintensity(100)) ///
box(2, fcolor(gs9) fintensity(100)) ///
box(3, fcolor(gs6) fintensity(100))  saving(fig4b.gph, replace)

graph combine fig4a.gph fig4b.gph, ycommon



*   ****************************************************************  *;
*   Table 1
*   ****************************************************************  *;


reg multipleframes4 know  
eststo m1
reg multipleframes4 know seniority oftendeal age gender 
eststo m2
reg multipleframes4 know seniority oftendeal age gender ideology1 ideology2 
eststo m3  

cd "/Users/ldell/"
#delimit ;
esttab m1 m2 m3 using table1.rtf, 
starlevels(* .10 ** .05 *** .01) b(%9.2f)  ar2(%9.2f)
se(%9.2f)  scalars(N) nodepvars  replace;
#delimit cr

* Robustness checks for SI Appendix

reg multipleframes4 know pref_coll  
eststo m4
reg multipleframes4 know  pref_reports  
eststo m5
reg multipleframes4 know  pref_power 
eststo m6
reg multipleframes4 know  pref_budget 
eststo m7
reg multipleframes4 know donor
eststo m8
reg multipleframes4 know pref_coll pref_reports pref_power pref_budget donor
eststo m9

#delimit ;
esttab m4 m5 m6 m7 m8 m9 using table1_robust.rtf, 
starlevels(* .10 ** .05 *** .01) b(%9.2f)  ar2(%9.2f)
se(%9.2f)   scalars(N) nodepvars  replace;
#delimit cr



*   ****************************************************************  *;
*   t-tests reported in figure legends
*   ****************************************************************  *;

tab io, gen(intorg)

ttest multipleframes4 if intorg1!=1, by(intorg2) // not UNEP 
ttest multipleframes4 if intorg2!=1, by(intorg1) // not UNHCR 
ttest multipleframes4 if intorg3!=1, by(intorg1) // not WHO 

ttest fr_humansec=fr_statesec
ttest fr_humansec=fr_health
ttest fr_humansec=fr_migr
ttest fr_statesec=fr_migr
ttest fr_statesec=fr_health
ttest fr_migr=fr_health

ttest fr_humansec if intorg1!=1, by(intorg2) // not UNEP 
ttest fr_humansec if intorg2!=1, by(intorg1) // not UNHCR 
ttest fr_humansec if intorg3!=1, by(intorg1) // not WHO 

ttest fr_statesec if intorg1!=1, by(intorg2) // not UNEP 
ttest fr_statesec if intorg2!=1, by(intorg1) // not UNHCR 
ttest fr_statesec if intorg3!=1, by(intorg1) // not WHO 

ttest fr_health if intorg1!=1, by(intorg2) // not UNEP 
ttest fr_health if intorg2!=1, by(intorg1) // not UNHCR 
ttest fr_health if intorg3!=1, by(intorg1) // not WHO 

ttest fr_migr if intorg1!=1, by(intorg2) // not UNEP 
ttest fr_migr if intorg2!=1, by(intorg1) // not UNHCR 
ttest fr_migr if intorg3!=1, by(intorg1) // not WHO 

ttest pref_coll if intorg1!=1, by(intorg2) // not UNEP 
ttest pref_coll if intorg2!=1, by(intorg1) // not UNHCR 
ttest pref_coll if intorg3!=1, by(intorg1) // not WHO 

ttest pref_reports if intorg1!=1, by(intorg2) // not UNEP 
ttest pref_reports if intorg2!=1, by(intorg1) // not UNHCR 
ttest pref_reports if intorg3!=1, by(intorg1) // not WHO 

ttest pref_power if intorg1!=1, by(intorg2) // not UNEP 
ttest pref_power if intorg2!=1, by(intorg1) // not UNHCR 
ttest pref_power if intorg3!=1, by(intorg1) // not WHO 

ttest pref_budget if intorg1!=1, by(intorg2) // not UNEP 
ttest pref_budget if intorg2!=1, by(intorg1) // not UNHCR 
ttest pref_budget if intorg3!=1, by(intorg1) // not WHO 
 
ttest donors if intorg1!=1, by(intorg2) // not UNEP 
ttest donors if intorg2!=1, by(intorg1) // not UNHCR 
ttest donors if intorg3!=1, by(intorg1) // not WHO 

ttest know if intorg1!=1, by(intorg2) // not UNEP 
ttest know if intorg2!=1, by(intorg1) // not UNHCR 
ttest know if intorg3!=1, by(intorg1) // not WHO 
 
exit

